define(['app'], function (app) {
	'use strict';

	app.controller('LandingController',
		function ($scope, $state, pageService, globalDelayTracker, focusService, config, mhpuser, landingService, formatter) {
		// set focus after template has rendered
		var stopWatch = $scope.$watch('globalDelayTracker.active()', function(newValue, oldValue) {
			focusService.focusMain();

			stopWatch();
		});

		$scope.formatter = formatter;

		$scope.userFirstLastName = mhpuser.firstName + ' ' + mhpuser.lastName;

		$scope.today = new Date();
		$scope.appTitle = config.app.title;

		$scope.toolSetItems = landingService.toolSetItems;

		$scope.$on("$stateChangeSuccess", function(event, toState, toParams, fromState){
			if ($state.current.data && $state.current.data.secondaryTitle) {
				$scope.secondaryTitle= $state.current.data.secondaryTitle;
			} else {
				$scope.secondaryTitle="";
			}
		});

		$scope.open_module = function(nextState) {
			$state.go(nextState);
			focusService.focusElement($('h1.main-title'));
		};

		$scope.goHome = function() {
			$state.go('main.auth.home');
		};
	});
});
